
        nolist
	include 'init'
	list
        title 'T.Leconte digital AM/FM/SSB Demodulator (c) 2001'



;*************************************************************************
	org	x:$400
	include	'filter'

	org	p:

;	ori    #$7,mr           ; diseable interrupts for debuging only
	andi #%11110011,mr      ;scaling bits = 00

        move #-1,m0		; r0 r1 to address the coeff. of all filters
        move #-1,m1   		; or any other linear structures

	move #IFilterTap,r4	 ; I Filter
	move r4,y:IFilterPtr

	move #QFilterTap,r4	 ; Q Filter
	move r4,y:QFilterPtr

	move #AudioFilterTap,r4	 ; Audio Filter
	move r4,y:AudioFilterPtr

	; mode selector input
	movep	#0,x:PBC
	movep	#0,x:PBDDR
;
main_loop

	jset    #2,x:SSISR,*            ; Wait for frame sync to pass.
	jclr    #2,x:SSISR,*            ; Wait for frame sync.
	        
	; get input sample
        move    x:RX_BUFF_BASE,x0        
	move	x:RX_BUFF_BASE+1,y0

	move	#-0.0122,a		; compensate gain and offset missmatch 
	move	#0.98,x1		; between I and Q in analog front end
	macr	x0,x1,a
	move	a,y:IInput		; to be set according to your implementation
	move	#-0.0113,b
	move	#0.9999999,y1
	macr	y0,y1,b
	move	b,y:QInput

_filters
	move #InputLen-1,m4
	move y:IFilterPtr,r4
	move y:IInput,a
	move a,y:-(r4)		
	move r4,y:IFilterPtr

	jset	#9,x:PBD,_ssbfi		; select I filter 
	move	#AMFMFilter,r1		; according to mode
	jmp	ifilter
_ssbfi	move	#SSBIFilter,r1
	nop

ifilter
       clr a  x:(r1)+,x0 y:(r4)+,y0
       .loop #IQFilterLen-1
         mac x0,y0,a  X:(r1)+,x0  y:(r4)+,y0
	.endl
       macr x0,y0,a
	
	move y:QFilterPtr,r4
	move y:QInput,b
	move b,y:-(r4)		
	move r4,y:QFilterPtr

	jset	#9,x:PBD,_ssbfq		; select Q filter
	move	#AMFMFilter,r1		; according to mode
	jmp	qfilter
_ssbfq	move	#SSBQFilter,r1
	nop

qfilter
       clr b  X:(r1)+,x0 y:(r4)+,y0
       .loop #IQFilterLen-1
         mac x0,y0,b  X:(r1)+,x0  y:(r4)+,y0
	.endl
       macr x0,y0,b

	jclr	#9,x:PBD,amfm

ssb
	; a= I
	; b= 90 shifted Q

	jclr	#8,x:PBD,_lsb

_usb	;  USB demod
	add	b,a		; a=(I + shifted Q)/2
	asr	a
	jmp  audiofilter

_lsb	;  LSB demod
	sub	b,a		; a=(I - shifted Q)/2
	asr	a
	jmp	audiofilter

amfm
	jsr	cordic
	; a=phi b = mag

	move	y:LastPhi,x0
	move	a,y:LastPhi
	sub	x0,a		; freq= delta Phi
	jec	_tuning
	jge	_dphi		; case when successive phase sample are not 
	move	#0,a2		; of the same sign
	jmp	_tuning		; triky isn't it ?
_dphi	move	#-1,a2
	; a=freq

_tuning move	a,x0		; average freq
tuning_alpha	equ	10.0/9600.0
	move	#tuning_alpha,y0
	mpy	x0,y0,a
	move	#1.0-tuning_alpha,y0
	move	y:TuningFreq,x1
	macr	x1,y0,a
	move	a,y:TuningFreq
	
	jclr	#8,x:PBD,_fm

_am				; am demod : just filter magnitude
	move	b,a
	jmp	audiofilter

_fm	
	sub	x0,a		; compense misstuning
	move	a,x0
	move	#0.5/(3000.0/4800.0),y0		; multiply according to freq shift
	mpy	-x0,y0,a
	asl	a

	;Audio Filter
audiofilter
	move y:AudioFilterPtr,r4
	move #AudioFilterLen-1,m4
     	move #AudioFilter,r1

	move a,y:-(r4)		
	move r4,y:AudioFilterPtr

        clr a  x:(r1)+,x0 y:(r4)+,y0
        .loop #AudioFilterLen-1
         mac x0,y0,a  X:(r1)+,x0  y:(r4)+,y0
	.endl
        macr x0,y0,a

	; Audio Output
        move    a,x:TX_BUFF_BASE

	jmp     main_loop

	include	'cordic'


LastD = *

;*************************************************************************
;Internal data RAM

        LOMEM X:$0000,y:$0000,L:$0000
        HIMEM X:$00FF,y:$00FF,L:$00FF

	org y:

IInput		dc	0
QInput		dc	0
IFilterPtr	dc	0
QFilterPtr	dc	0
AudioFilterPtr	dc	0
LastPhi		dc	0
TuningFreq	dc	0

;*************************************************************************
;External data RAM


          LOMEM X:$1C00,y:$0100,L:$1C00
          HIMEM X:$3FFF,y:$3FFF,L:$3FFF

        org y:$100

InputLen	equ	128

IFilterTap dsm InputLen
QFilterTap dsm InputLen
AudioFilterTap dsm AudioFilterLen


;*************************************************************************

